/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.DefaultStatus;
import ibm.nways.jdm8260.DeviceView.GrayableLike;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.PortLike;
import ibm.nways.jdm8260.DeviceView.StatusRefLike;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.io.Serializable;

public class Port
implements PortLike,
StatusRefLike,
GrayableLike {
    protected int slot;
    protected int subSlot;
    protected int portNumber;
    protected int portType;
    protected int modType;
    protected int network;
    protected GraphicImage portGraphicImage;
    protected GraphicContainer graphicContainer;
    protected String cookieID;
    protected HubInfoLike hub;
    protected String destinationPanel;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8260.DeviceView.GraphicResources";
    protected static final String SER_PATH = "ibm.nways.jdm8260.WCDefault";
    protected static final int COOKIE_FLAGS = 28;
    protected Status statusRef;
    protected GenModel portModel;
    public static final int RJ45 = 0;
    public static final int FC = 1;
    public static final int BNC = 2;
    public static final int AUI_MALE = 3;
    public static final int MAUI = 3;
    public static final int AUI_FEMALE = 4;
    public static final int FAUI = 4;
    public static final int TELCO = 5;
    public static final int FDDI = 6;
    public static final int DB9 = 7;
    public static final int RS232 = 8;
    public static final int ATM155 = 9;
    public static final int A8MPEG = 10;
    public static final int A04MBBRG = 11;
    public static final int A8229ETH = 12;
    public static final int A8229TRI = 13;
    public static final int A8235PORT = 14;
    public static final int FDDI_DOUBLE = 15;
    public static final int LOGICAL_12 = 16;
    public static final int LOGICAL_16 = 17;
    public static final int SC = 18;
    public static final int LOGICAL_E1 = 19;
    public static final int MIC = 20;
    public static final int FIBER = 21;
    public static final int DB37 = 22;
    public static final int ESCON = 23;
    protected static final String[] PORT_TYPE = new String[]{"Port_rj45", "Port_fiber", "Port_bnc", "Port_aui", "Port_aui", "Port_telco", "Port_fddi", "Port_db9", "Port_rs232", "Port_rj45", "Port_bnc", "Port_rj45", "Port_rj45", "Port_rj45", "Port_rj45", "Port_fddi", "Port_rj45", "Port_rj45", "Port_sc", "Port_db9", "Port_mic", "Port_fiber", "Port_db37", "Port_escon"};

    public void dispose() {
        this.portModel = null;
        this.graphicContainer = null;
        this.portGraphicImage = null;
        this.hub = null;
        this.statusRef = null;
    }

    public void setStatusRef(Status status) {
        this.statusRef = status;
    }

    public Status getStatusRef() {
        return this.statusRef;
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, int n6, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        this.hub = hubInfoLike;
        this.cookieID = string;
        this.slot = n;
        this.subSlot = n2;
        this.portNumber = n3;
        this.portType = n4;
        this.modType = n6;
        this.graphicContainer = graphicContainer;
        this.network = this.getPortNetwork(n5);
        this.portModel = genModel;
        this.destinationPanel = string2;
    }

    public void setSpecificInformation() {
    }

    public void draw() {
        WidgetCookie widgetCookie = null;
        ModelInfo modelInfo = this.getModelInfo();
        GenModel genModel = this.getGenModel();
        widgetCookie = new WidgetCookie(this.cookieID, BUNDLE_NAME, modelInfo, SER_PATH, genModel, this.hub.getBrowser(), 28, this.getDestinationPanel());
        this.portGraphicImage = widgetCookie.GetImage();
        I18NMsgFormat i18NMsgFormat = this.getFlyOverText();
        this.statusRef = DefaultStatus.getDefaultStatus();
        this.portGraphicImage.setStatus(this.statusRef);
        if (genModel != null) {
            this.hub.askStatus(genModel, this.portGraphicImage, modelInfo, this);
        }
        this.portGraphicImage.setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
        this.graphicContainer.add((GraphicContainer)widgetCookie);
    }

    public void gray() {
        String string = "gray";
        if (this.portGraphicImage.getStatus() != DefaultStatus.getDefaultStatus()) {
            this.portGraphicImage.setVisible(false);
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Port grayed: " + this);
            }
        }
    }

    public void ungray() {
        String string = "ungray";
        if (this.statusRef != null) {
            this.portGraphicImage.setVisible(true);
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Port highlighted: " + this);
            }
        }
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.PortSlotIndex", new Integer(this.slot));
        modelInfo.add("Index.PortSubSlotIndex", new Integer(this.subSlot));
        modelInfo.add("Index.PortIndex", new Integer(this.portNumber));
        return modelInfo;
    }

    public GenModel getGenModel() {
        return this.portModel;
    }

    public String getDestinationPanel() {
        return this.destinationPanel;
    }

    public I18NMsgFormat getFlyOverText() {
        String string = "getFlyOverText";
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(this.portNumber);
        String string2 = "Port_unspecified_conn";
        try {
            string2 = PORT_TYPE[this.portType];
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Cannot find fly-over for port type -> " + this.portType);
            }
            RAS.logException(19, 2, this, string, exception);
        }
        objectArray[1] = this.hub.getBundle().getString(string2);
        return new I18NMsgFormat(BUNDLE_NAME, "Port", objectArray);
    }

    public boolean findMACAddress() {
        return false;
    }

    public GraphicImage getGraphicImage() {
        return this.portGraphicImage;
    }

    protected int getPortNetwork(int n) {
        Serializable serializable = this.hub.getMibInfo().getVar("ocPortNetwork", "." + this.slot + "." + this.subSlot + "." + this.portNumber);
        int n2 = 4;
        if (serializable instanceof MibValue) {
            n2 = ((MibValue)serializable).getIntValue();
        }
        return this.checkNetwork(n2, n);
    }

    private int checkNetwork(int n, int n2) {
        int n3 = n == 4 ? n2 : n;
        this.hub.getNetworksWindow().addObjectToNetwork(n3, this);
        return n3;
    }

    public String toString() {
        return "Slot -> " + this.slot + " SubSlot -> " + this.subSlot + " portNumber -> " + this.portNumber;
    }
}

